#ifndef __GUIDefines__
#define __GUIDefines__

/**
 * @file GUIDefines.h
 * @brief Defintions of a few important things for the GUI package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: GUIDefines.h,v 1.4 2007/02/11 02:16:22 paul Exp $
 */

#include <Basics/CCountedObject.hpp>

/**
 * @cond
 */
#ifdef WIN32

	// Did visual studio programmers forget something or did i??
	#ifndef CS_DROPSHADOW
		#define CS_DROPSHADOW 0x00020000
	#endif

	#ifndef WS_EX_LAYERED
		#define WS_EX_LAYERED 0x80000
	#endif

	#ifndef WS_EX_NOACTIVATE
		#define WS_EX_NOACTIVATE 0x08000000L
	#endif

	#ifndef LWA_COLORKEY
		#define LWA_COLORKEY 1
	#endif

	#ifndef LWA_ALPHA
		#define LWA_ALPHA 2
	#endif

	#ifndef GET_WHEEL_DELTA_WPARAM
		#define GET_WHEEL_DELTA_WPARAM(wparam) ((short)HIWORD (wparam))
	#endif

	#ifndef WHEEL_DELTA
		#define WHEEL_DELTA 120
	#endif

	#ifndef IDC_TEXT
		#define IDC_TEXT 1000
	#endif

	#ifndef GET_X_LPARAM
		#define GET_X_LPARAM(lParam) ((int)(short)LOWORD(lParam))
	#endif

	#ifndef GET_Y_LPARAM
		#define GET_Y_LPARAM(lParam) ((int)(short)HIWORD(lParam))
	#endif


	//	===========================================================================

	// Typedef for set layered window attributes
	typedef DWORD (WINAPI *SETLAYERATTRIBUTE)(HWND, DWORD, BYTE, DWORD);

	// Typedef for alpha blend
	typedef BOOL (WINAPI *ALPHABLEND)(HDC, int, int, int, int, HDC, int, int, int, int, BLENDFUNCTION);


	//	===========================================================================

	#pragma warning (disable : 4311)	// Truncation from CToolTip * to LONG
	#pragma warning (disable : 4312)	// Conversion from LONG to CToolTip * of greater size
	#pragma warning (disable : 4244)	// Conversion from 'WPARAM' to 'int', possible loss of data
	#pragma warning (disable : 4244)	// conversion from LONG_PTR to LONG possilbe truncation of data
	#pragma warning (disable : 4204)	// vc70.pdb' is missing debugging information for referencing module; linking object as if no debug info
	#pragma warning (disable : 4326)	// return type of 'main' should be 'int or void' instead of 'AEffect *'
	#pragma warning (disable : 4017)	// DESCRIPTION statement not supported for the target platform; ignored

#else


#endif
/**
 * @endcond
 */

#endif	// End of GUIDefines.h